<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ClientLicense extends Model
{
    use HasFactory;
    use SoftDeletes;
    protected $fillable = [
        'unique_client_code',
        'client_mail_id',
        'product_code',
        'license_no',
        'license_key',
        'registration_date',
        'status'
    ];
    public function getProductCode()
    {
        return $this->belongsTo(Product::class,'product_code');
    }
}
