<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use App\Models\Currency;

class Company extends Model
{
    use HasFactory,SoftDeletes;
    protected $table      ="companies";
    protected $primaryKey = "id";
    protected $fillable   = [
        'name',
        'email',
        'code',
        'branch_name',
        'branch_code',
        'office_type',
        'mobile_number',
        'phone_number',
        'whatsapp_no',
        'logo',
        'aadhaar_number',
        'gst_number',
        'pan_number',
        'cst_number',
        'license_number',
        'status',
        'is_default',
        'letter_head',
        'website',
        'deals_in',
        'tag_line',
        'establishment_type_id',
        'date_format',
        'time_format',
        'time_zone',
        'language_id',
        'currency_id',
    ];
    protected $appends = ['file_url'];

    public function getFileUrlAttribute()
    {
        $image = \App\Models\CompanyImage::select('image_url')
            ->where('company_id', $this->id)
            ->where('image_type', 'logo')
            ->where('status', '1')
            ->first();
        //dd($image);
        if (isset($image->image_url) && $image->image_url!='') {
            
            $bucket_data = \App\Models\StorageSetting::where(['storage_type'=>'s3_bucket'])->first();
            if ($bucket_data) {
                config([
                    'filesystems.disks.s3.key'    => $bucket_data->access_key,
                    'filesystems.disks.s3.secret' => $bucket_data->secret_key,
                    'filesystems.disks.s3.region' => $bucket_data->region,
                    'filesystems.disks.s3.bucket' => $bucket_data->bucket_name,
                ]);

                $temporarySignedUrl = \Storage::disk('s3')->temporaryUrl($bucket_data->main_folder . '/' . $image->image_url, now()->addMinutes(10));

                return $temporarySignedUrl;
            }
        }

        return '';
    }

    public function getCompanyImage()
    {
        return $this->hasOne(CompanyImage::class,'company_id','id')->where('image_type','logo');
    }

    public function getCompanyAddress()
    {
            return $this->hasOne(CompanyAddress::class,'company_id','id')->whereNull('deleted_at')->where('is_default',1)->with('getComapnyCountry')->with('getComapnyCity')->with('getComapnyState');
    }
    public function getCompanyName()
    {
            return $this->hasOne(CompanyAddress::class,'company_id','id')->select(['company_id','address_1']);
    }
    public function getCompanybank()
    {
            return $this->hasOne(CompanyBank::class,'company_id','id');
    }
    public function getCompanyLicence()
    {
            return $this->hasMany(CompanyLicence::class,'company_id','id');
    }

    public function language()
    {
        return $this->hasOne(Language::class, 'id', 'language_id');
    }

    public function currency()
    {
        return $this->hasOne(Currency::class, 'id', 'currency_id');
    }

    static public function companyDateFormat()
    {
        $company = self::with('dateFormat')->find(\Auth::user()->company_id);

        if (!$company) {
            $company = self::with('dateFormat')->where('is_default', '1')->first();
        }

        return $company->date_format ?? "m-d-Y";
    }

    static public function companyTimeFormat()
    {
        $company = self::select('time_format')->find(\Auth::user()->company_id);

        if (!$company) {
            $company = self::select('time_format')->where('is_default', '1')->first();
        }

        return $company->time_format ?? "H:i:s";
    }

    static public function companyDateTimeFormat()
    {
        $company = self::select('date_format', 'time_format')->find(\Auth::user()->company_id);

        if (!$company) {
            $company = self::select('date_format', 'time_format')->where('is_default', '1')->first();
        }

        $dateFormat = $company->date_format ?? "m-d-Y";
        $timeFormat = $company->time_format ?? "H:i:s";

        return $dateFormat .' ' . $timeFormat;
    }

    static public function companyTimeZone()
    {
        $company = self::select('time_zone')->find(\Auth::user()->company_id);

        if (!$company) {
            $company = self::select('time_zone')->where('is_default', '1')->first();
        }

        $timeFormat = $company->time_format ?? "Asia/Kolkata";

        return $timeFormat;
    }

    static public function companyCurrencyCode()
    {
        $company = self::select('country_currencies.code as currency_code', 'country_currencies.currency', 'country_currencies.id')
            ->leftjoin('country_currencies','country_currencies.id','companies.currency_id')
            ->find(\Auth::user()->company_id);

        if (!$company) {
            $company = Currency::select('code as currency_code', 'country_currencies.currency')
                ->where('is_default', '1')
                ->first();
        }

        return $company;
    }
    public function dateFormat()
    {
        return $this->hasOne(DateFormat::class,'id','date_format');
    }
    public function getZone()
    {
        return $this->belongsTo(Timezone::class,'time_zone','id');
    }
}
