<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CompanyAddress extends Model
{
    use HasFactory;
    protected $table      = "companies_addresses";
    protected $primaryKey = "id";
    protected $fillable   = [
        'company_id',
        'address_1',
        'address_2',
        'country_id',
        'state_id',
        'city_id',
        'pin_code',
        'google_place_link',
        'location_latitude',
        'location_longitude',
        'is_default',
        'status',
        'priority',
        'district_name',
        'taluka_name',
        'address_type_id',
    ];

    public function getComapnyCountry()
    {
            return $this->hasOne(Country::class,'id','country_id');
    }
    public function getComapnyCity()
    {
            return $this->hasOne(City::class,'id','city_id');
    }
    public function getComapnyState()
    {
            return $this->hasOne(State::class,'id','state_id');
    }

    static public function getCompanyAddress($where = [])
    {
        $query = self::select(
                    'countries.code as country_code',
                    'companies_addresses.country_id',
                    'companies_addresses.state_id',
                    'companies_addresses.city_id',
                )
                ->leftjoin('countries', 'countries.id', 'companies_addresses.country_id')
                ->where($where)
                ->first();

        return $query;
    }
}
