<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CompanyImage extends Model
{
    use HasFactory;
    use SoftDeletes;

    protected $fillable = [
        'company_id',
        'image_url',
        'image_type',
        'status',
        'priority',
        'height width',
        'top_margin',
        'bottom_margin',
        'left_margin ',
        'right_margin',
        'top_padding',
        'bottom_padding',
        'left_padding',
        'right_padding',
        'alignment',
        'height',
        'width'
    ];
    protected $appends = ['file_url'];

    public function getFileUrlAttribute()
    {
        if ($this->image_url != '') {
            return getTempUrl($this->image_url);
        }

        return '';
    }
    public function getCompanyName()
    {
        return $this->hasOne(Company::class,'id','company_id')->select(['id','name']);
    }
}
