<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CompanyLicence extends Model
{
    use HasFactory,SoftDeletes;
    protected $table      = "companies_license";
    protected $primaryKey = "id";
    protected $fillable   = [
        'company_id',
        'license_name',
        'license_number',
        'valid_from',
        'valid_upto',
        'license_status',
        'is_default',
        'priority',
        'license_type_id',
        'attachment',
        'page_position',
        'view_priority'
    ];
    protected $appends = ['file_url'];

    public function getFileUrlAttribute()
    {
        if ($this->attachment != '') {
            return getTempUrl($this->attachment);
        }

        return '';
    }

    public function getLicenseName()
    {
            return $this->hasOne(CompanyLicenceType::class,'license_name','id');
    }
}
