<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CompanyLicenceType extends Model
{
    use HasFactory,SoftDeletes;
    protected $table      = "companies_license_type";
    protected $primaryKey = "id";
    protected $fillable   = [
        'company_id',
        'country_id',
        'license_type_name',
        'license_code',
        'license_status',
        'data_length',
        'value_type',
        'is_mandatory',
        'priority',
        'show_in_print'
    ];

    public function getCompanyName()
    {
        return $this->hasOne(Company::class,'id','company_id')->select(['id','name']);
    }
}
