<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ContraVoucher extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable   = [
		'voucher_no',
		'transaction_date',
		'reference',
		'description',
		'company_id',
		'financial_year_id',
		'voucher_status',
		'created_by',
		'voucher_approval_status',
		'last_voucher_count',
        'voucher_master_id',
        'receipt_time'
    ];

    public function contraVoucherTransaction(){
        return $this->hasMany(ContraVoucherTransaction::class,'voucher_id','id');
    }

    public function financialYear(){
        return $this->hasOne(FinancialYear::class,'financialyearid','financial_year_id');
    }

    public function company(){
        return $this->hasOne(Company::class,'id','company_id');
    }

    public function voucherTerm(){
        return $this->hasOne(VoucherTerm::class,'voucher_id','voucher_master_id')->where('status', '1')->orderBy('is_default','Desc');
    }

    public function voucherMaster(){
        return $this->hasOne(VoucherMaster::class,'id','voucher_master_id')->with('voucherType');
    }

    public function user(){
        return $this->hasOne(User::class,'id','created_by');
    }
}
