<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Doctor extends Model
{
    use HasFactory;
    protected $fillable = [
        'account_id',
        'doctors_chamber_id',
        'qualification',
        'organization_department_id',
        'opd_schedule_types_id',
        'shift_id',
        'specialist_in',
        'medical_license_no',
        'api_salt_key',
        'priority',
        'status',
        'default',
        'web_booking',
        'app_booking',
        'language_id',
        'experience',
        'gap_between_two_patient',
        'convert_to_sale'
    ];

    public function getAccount()
    {
          return $this->belongsTo(Account::class,'account_id')->with('account_images');
    }
    public function getOrganizatioDepartment()
    {
          return $this->belongsTo(OrganizationDepartment::class,'organization_department_id');
    }
    public function getOpdSchedule()
    {
          return $this->belongsTo(OpdScheduleType::class,'opd_schedule_types_id');
    }
    public function getShift()
    {
          return $this->belongsTo(AppointmentShift::class,'shift_id');
    }
    public function getDoctorAppointmentshift()
    {
          return $this->hasMany(AppointmentDoctorShift::class,'doctor_id')->with('getShifts');
    }
    public function getDoctorLanguage()
    {
          return $this->belongsTo(Language::class,'language_id');
    }
}
