<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DocumentManagement extends Model
{
    use HasFactory;

    protected $appends = ['file_temp_url', 'voucher_name'];

    protected $fillable = [
		'document_no',
		'date_time',
		'voucher_id',
		'voucher_type',
		'document_note',
		'file_url',
		'account_id',
		'company_id',
		'user_id',
		'priority',
		'status',
		'is_default',
		'last_voucher_count',
        'file_types'
    ];

    public function getFileTempUrlAttribute()
    {
        if ($this->file_url != '') {
            return getTempUrl($this->file_url);
        }

        return '';
    }

    public function getVoucherNameAttribute()
    {
        $voucher = VoucherType::select('name')->where(['code' => $this->voucher_type])->first();

        return $voucher->name ?? '';
    }
}
