<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Employee extends Model
{
    use HasFactory;
    use SoftDeletes;
    protected $fillable = [
        'account_id',
        'employee_type_id',
        'designation_id',
        'department_id',
        'gender_id',
        'reporting_to',
        'language_id',
        'title_id',
        'name',
        'email',
        'date_of_birth',
        'joining_date',
        'phone_no',
        'role_in_project_id',
        'address',
        'about',
        'skills',
        'probation_end_date',
        'notice_period_start_date',
        'notice_period_end_date',
        'employment_type',
        'marital_status_id',
        'login_allowed',
        'recieve_email_notifications',
        'hourly_rate',
        'slack_member_id',
        'country_id',
        'state_id',
        'city_id',
    ];

    public function getDesignation()
    {
        return $this->belongsTo(Designation::class,'designation_id');
    }
    public function getDepartment()
    {
        return $this->belongsTo(OrganizationDepartment::class,'department_id');
    }

    public function getGender()
    {
        return $this->belongsTo(Gender::class,'gender_id');
    }

    public function getUser()
    {
        return $this->belongsTo(User::class,'reporting_to');
    }

    public function getLanguage()
    {
        return $this->belongsTo(Language::class,'language_id');
    }
    public function getTitle()
    {
        return $this->belongsTo(AccountTitle::class,'title_id');
    }
    public function getEmployeeType()
    {
        return $this->belongsTo(EmployeeType::class,'employee_type_id');
    }
    public function getRole()
    {
        return $this->belongsTo(ProjectTeam::class,'role_in_project_id');
    }

    public function getCity()
    {
        return $this->belongsTo(City::class,'city_id');
    }

    public function getAccount()
    {
        return $this->belongsTo(Account::class,'account_id');
    }

    public function getAccountAddress()
    {
        return $this->belongsTo(AccountAddress::class,'account_id');
    }

}
