<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class FinancialYear extends Model
{
    use HasFactory,SoftDeletes;

    protected $table      = "tbl_financial_year";
    protected $primaryKey = "financialyearid";
    protected $fillable   = [
        'financial_year_start_date',
        'financial_year_end_date',
        'financial_year_name',
        'table_postfix',
        'company_id',
        'status',
        'is_default',
        'financial_year_short_code',
        'current_financial_year',
    ];

    public function getComapnyName()
    {
            return $this->hasOne(Company::class,'id','company_id');
    }

    static public function getComapnyFinancialYear()
    {
        $company_id = \Auth::user()->company_id;

        if ($company_id) {
            $financialyear = FinancialYear::where(['company_id' => $company_id, 'status' => 1])
                ->where('is_default', '1')
                ->first();

            return $financialyear;
        }

        return '';
    }
}
