<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class HolidaySetting extends Model
{
    use HasFactory;
    use SoftDeletes;
    protected $table="holiday_settings";
    protected $fillable = [
        'account_id',
        'from_date',
        'to_date',
        'shift_id',
        'status',
        'chamber_id'
    ];

    public function getShift()
    {
          return $this->belongsTo(AppointmentShift::class,'shift_id');
    }
}
