<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class IncentiveSetting extends Model
{
    use HasFactory;
    use SoftDeletes;
    protected $fillable = [
        'account_id',
        'slab_id',
        'received_by',
        'status',
        'date_upto'
    ];
    public function getAccount()
    {
        return $this->belongsTo(Account::class,'account_id')->with('master_type');
    }
    public function getIncentiveSlab()
    {
        return $this->belongsTo(IncentiveSlab::class,'slab_id');
    }
}
