<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class IncentiveSlab extends Model
{
    use HasFactory;
    use SoftDeletes;
    protected $fillable = [
        'slab_name',
        'code',
        'account_type_id',
        'company_id',
        'calculation_type',
        'percentage',
        'price',
        'is_default',
        'status',
    ];
    public function getCompany()
    {
        return $this->belongsTo(Company::class,'company_id');
    }
    public function getType()
    {
        return $this->belongsTo(MasterType::class,'account_type_id');
    }
}
