<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class IncentiveSlabDetail extends Model
{
    use HasFactory;
    use SoftDeletes;
    protected $fillable = [
        'slab_id',
        'product_id',
        'calculation_type',
        'percentage',
        'price',
        'status'
    ];
    public function getslab()
    {
        return $this->belongsTo(IncentiveSlab::class,'slab_id');
    }
    public function getProduct()
    {
        return $this->belongsTo(Product::class,'product_id');
    }
}
