<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class InvoiceSerialSetting extends Model
{
    use HasFactory;
    protected $primaryKey = "id";
    protected $fillable = [
        'invoice_type_id',
        'company_id',
        'financial_year_id',
        'company_to_follow',
        'branch_wise_counter',
        'overall_counter',
        'serial_prefix',
        'serial_postfix',
        'no_of_zeros',
        'add_financial_year',
        'add_branch_code',
        'show_overall_serial_no'
    ];

    public function getFinancialYear(){
        return $this->hasOne(FinancialYear::class,'financialyearid','financial_id');
    }
}