<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class IpdDischarge extends Model
{
    use HasFactory;

    protected $fillable = [
		'ipd_admission_id',
		'discharge_datetime',
		'discharge_type_code',
		'condition_of_discharge',
		'special_note',
		'next_follow_up_date',
		'referral_date_time',
		'referral_hospital_name',
		'reason_for_referral',
		'death_date_time',
		'file_attachment',
		'family_contact',
		'discharge_status',
		'advise_on_discharge',
		'created_by_id',
		'edited_by_id',
		'deleted_by_id',
		'course_during_hosp',
		'post_operation',
		'explained_by',
		'understood_by',
		'signed_status',
		'signed_by',
		'signed_at',
	];

    public function get_admission_details()
    {
        return $this->belongsTo(IpdAdmission::class, 'ipd_admission_id')->with('contacts');
    }

    public function consultantHistory()
    {
        return $this->belongsTo(IpdConsultantHistory::class, 'ipd_admission_id', 'id')->with('consultants');
    }
}
