<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class LetterHead extends Model
{
    use HasFactory;

    protected $casts = [
    'image_style'     => 'array',
    'title_style'     => 'array',
    'sub_title_style' => 'array',
    ];

    protected $fillable = [
        'voucher_type_code',
        'full_image',
        'image_url',
        'image_style',
        'title_style',
        'sub_title_style',
        'content_alignment',
        'logo_position',
        'company_id',
        'status',
        'is_default',
        'custom_logo_url',
        'custom_logo_status',
        'title',
        'hide_logo',
    ];

    static public function voucherLetterHead($where=[])
    {
        return self::select(
            'letter_heads.id',
            'letter_heads.full_image as full_image',
            'letter_heads.image_url as image_url',
            'letter_heads.image_style as image_style',
            'letter_heads.title_style as title_style',
            'letter_heads.sub_title_style as sub_title_style',
            'letter_heads.content_alignment as content_alignment',
            'letter_heads.logo_position as logo_position',
            'letter_heads.company_id as company_id',
            'letter_heads.custom_logo_status',
            'letter_heads.custom_logo_url',
            'letter_heads.hide_logo',
            'letter_heads.status as status',
            'letter_heads.is_default as is_default',
            'voucher_types.name as voucher_type_code'
        )
        ->leftJoin('voucher_types' , 'voucher_types.letter_head_id' , '=' , 'letter_heads.id')
        ->where($where)
        ->where('letter_heads.status', '1')
        ->first();
    }
}
