<?php

namespace App\Models\Library;

use App\Models\Account;
use App\Models\FinancialYear;
use App\Models\Librarian\Books;
use App\Models\Students\Student;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use DB;

class BookIssue extends Model
{
    use HasFactory;
    protected $primaryKey = "id";
    protected $fillable = ['account_id',
                            'financial_id',
                            'remark',
                            'amount',
                            'status',
                            'issue_no',
                            'issue_date',
                            'last_issue_no_count',
                            'request_id',
                            'return_due_date'
                        ];
    public function getStudentDetails()
    {
    return $this->hasOne(Account::class,'id','account_id');
    }

    public function getStudentAllDetails()
    {
        return $this->hasOne(Account::class,'id','account_id');
    }
    public function getFinancialyear()
    {
        return $this->hasOne(FinancialYear::class,'financialyearid','financial_id')->select(['financialyearid','financial_year_name']);
    }

    
    public function issueDetails()
    {
        return $this->hasMany(BookIssueDetail::class);
        //$wordCount = $wordlist->count();
    }


    public function details()
    {
        return $this->hasMany(BookIssueDetail::class)->select(['book_issue_id',DB::raw('SUM(qnt) as qnt')])->groupBy('book_issue_id');
    }


    // for reports
    public function getStudents()
    {
    return $this->hasOne(Account::class,'id','account_id')->with('getLibraryCard');
    }
    

}
