<?php

namespace App\Models\Library;

use App\Models\Product;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class BookIssueDetail extends Model
{
    use HasFactory;
    protected $primaryKey = "id";
    protected $fillable = ['book_issue_id',
                            'product_id',
                            'qnt',
                            'return_status',
                            'return_due_date',
                            'return_date'
                        ];

    public function getBookDetails()
    {
        return $this->hasOne(Product::class,'product_id','id')->select(['id','book_title']);
    }
    public function book()
    {
        return $this->hasOne(Product::class, 'id','product_id');
    }

    public function user()
    {
        return $this->belongsTo(BookIssueDetail::class);
    }


    public function getBookreport()
    {
        return $this->hasOne(Product::class,'id','book_id')->select(['id','book_title','isbn_no']);
    }

    public function getisseuBookreport()
    {
        return $this->hasOne(BookIssue::class,'id','book_issue_id')->select(['id','account_id','issue_date']);
    }
    public function getisseuBook()
    {
        return $this->hasOne(BookIssue::class,'id','book_issue_id')->select(['id','account_id','issue_date'])->with('getStudentDetails');
    }

    
    
}
