<?php

namespace App\Models\Library;

use App\Models\Account;
use App\Models\Students\Student;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class BookRequest extends Model
{
    use HasFactory;
    protected $table="book_request";
    protected $primaryKey = "id";
    protected $fillable = ['order_no',
                            'order_date',
                            'status',
                            'student_id'
                        ];
    public function getRequestDetail()
    {
        return $this->hasMany(BookRequestDetail::class,'book_reques_id','id');
    }
    public function getStudents()
    {
        return $this->hasOne(Account::class,'id','student_id')->select(['id','name','unique_register_no']);
    }
    public function bookcount()
    {
        return $this->hasMany(BookRequestDetail::class,'book_reques_id','id')->select(['book_reques_id',DB::raw('count(qnt) as qnt')])->groupBy('book_reques_id');
    }
}
