<?php

namespace App\Models\Library;

use App\Models\Librarian\Books;
use App\Models\Product;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class BookRequestDetail extends Model
{
    use HasFactory;
    protected $table="book_request_details";
    protected $primaryKey = "id";
    protected $fillable = ['book_reques_id',
                            'book_id',
                            'qnt',
                            'status'
                        ];
    public function getBook()
    {
        return $this->hasOne(Product::class,'id','book_id')->select(['id','short_name','shortcode'])->with(['book_details']);
    }
    public function getBookRequest()
    {
        return $this->hasOne(BookRequest::class,'id','book_reques_id');
    }
    
}
