<?php

namespace App\Models\Library;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class BookReturnDetail extends Model
{
    use HasFactory;
    protected $primaryKey = "id";
    protected $fillable =   ['book_return_id',
                            'book_issue_detail_id',
                            'product_id',
                            'return_date',
                            'return_no',
                            'damage_status',
                            'amount',
                            'damage_qty',
                            'return_qty',
                            ];
    public function getIssuedetails()
    {
        return $this->hasOne(BookIssueDetail::class,'id','book_issue_detail_id')->with(['getisseuBook','book']);
    }
}
