<?php

namespace App\Models\Library;

use App\Models\Academics\Classes;
use App\Models\Academics\ClassSection;
use App\Models\Academics\Section;
use App\Models\Account;
use App\Models\LmsClasses;
use App\Models\LmsSection;
use App\Models\Students\Student;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class LibraryCard extends Model
{
    use HasFactory;
    protected $primaryKey = "id";
    protected $fillable = ['account_id',
                            'card_type',
                            'membership_id',
                            'financial_id',
                            'admission_id',
                            'card_no',
                            'class_id',
                            'section_id',
                            'stream_id',
                            'date_of_issue',
                            'valid_upto',
                            'last_card_no_count',
                            'card_status'
                        ];
    public function getStudentDetails()
    {
        return $this->hasOne(Account::class,'id','account_id')->select(['id','name','unique_register_no']);
    }
    public function getClassName()
    {
        return $this->hasOne(LmsClasses::class,'id','class_id')->select(['id','class_name']);
    }
    public function getSectionName()
    {
        return $this->hasOne(LmsSection::class,'id','section_id')->select(['id','section as academics_section_id']);
    }
}
