<?php

namespace App\Models\LibrarySetting;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class BookDetails extends Model
{
    use HasFactory,SoftDeletes;
    protected $table="tbl_book_details";
    protected $primaryKey = "id";
    protected $fillable = ['book_id',
                            'book_series_title',
                            'book_no',
                            'book_series',
                            'book_rack_id',
                            'rack_row',
                            'rack_column',
                            'book_formate',
                            'edition',
                            'editor',
                            'print_year',
                            'released_date',
                            'price',
                            'no_of_pages',
                            'purchase_date',
                            'quantity',
                            'status'
                          ];
      public function getBookFormate()
      {
        return $this->hasOne(BookFormates::class,'id','book_formate');
      }
}
