<?php

namespace App\Models\LibrarySetting;

use App\Models\Library\BookIssueDetail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Books extends Model
{
    use HasFactory,SoftDeletes;
    protected $table="tbl_books";
    protected $primaryKey = "id";
    protected $fillable = ['isbn_no',
                            'manual_max_no',
                            'manual_isbn',
                            'book_title',
                            'about_book',
                            'pages',
                            'catgory_genres_id',
                            'author_id',
                            'publisher_id',
                            'stream_id',
                            'translator_id',
                            'laguages_id',
                            'book_class_id',
                            'book_tag_id',
                            'book_cover_small',
                            'book_cover_large',
                            'book_url',
                            'dimensions',
                            'status'
                          ];
  public function getAuthorName()
  {
      return $this->hasOne(LibrarianAuthors::class,'author_id','id')->select(['id','first_name']);
  }

  public function getBookItems()
  {
      return $this->hasMany(BookDetails::class,'book_id','id')
      ->select([
        'id','book_id','book_series_title','book_no','book_series','book_rack_id','rack_row','rack_column',
        'book_formate','edition','editor','print_year','released_date','price','no_of_pages','purchase_date',
        'purchase_date','quantity'
      ]);
  }
  public function issueDetail()
  {
        return $this->belongsTo(BookIssueDetail::class, 'book_id');
  }



  public function author()
  {
        return $this->hasOne(LibrarianAuthors::class, 'id','author_id')->select(['id','first_name']);
  }

  public function publisher()
  {
        return $this->hasOne(LibrarianPublishers::class, 'id','publisher_id')->select(['id','name']);
  }

  public function languages()
  {
        return $this->hasOne(LibrarianBookLanguages::class, 'id','laguages_id')->select(['id','lang_name']);
  }

  public function bookCategory()
  {
        return $this->hasOne(LibrarianGernes::class, 'id','catgory_genres_id')->select(['id','name']);
  }
  public function getStream()
  {
      return $this->hasOne(Stream::class, 'id','stream_id')->select(['id','stream_name']);
  }

  public function getClasses()
  {
      return $this->hasOne(BookClass::class, 'id','book_class_id')->select(['id','class_name']);
  }

  public function getTags()
  {
      return $this->hasOne(LibrarianTags::class, 'id','book_tag_id')->select(['id','tag_name']);
  }
  public function getTranslator()
  {
      return $this->hasOne(Translators::class, 'id','translator_id')->select(['id','translator_name']);
  }
  public function getBookDetails()
  {
      return $this->hasOne(BookDetails::class, 'book_id','id')->select(['id','price','book_id','released_date','purchase_date','book_formate','print_year','rack_row','rack_column']);
  }
}
