<?php

namespace App\Models\LibrarySetting;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\DB;

class LibrarianAuthors extends Model
{
    use HasFactory,SoftDeletes;
    protected $table="librarian_authors";
    protected $primaryKey = "id";
    protected $fillable = ['first_name',
                            'last_name',
                            'company_id',
                            'descriptions',
                            'authors_prfile_picture',
                            'cover_image_small',
                            'cover_image_large',
                            'website_view',
                            'isfeatured',
                            'status',
                        ];
    public function bookCount()
    {
        return $this->hasMany(Books::class,'author_id','id')->select(['author_id',DB::raw('count(id) as count')]);
    }

}
