<?php

namespace App\Models\LibrarySetting;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\DB;

class LibrarianGernes extends Model
{
    use HasFactory, SoftDeletes;
    protected $table = "librarian_gernes";
    protected $primaryKey = "id";
    protected $fillable = [
        'name',
        'description',
        'isfeatured',
        'status',
        'cover_image_small',
        'cover_image_large',
        'website_view',
        'code'
    ];
    public function getBookData()
    {
        return $this->hasMany(Books::class, 'catgory_genres_id', 'id')->select(['id', 'book_title'])->limit(4)->latest();
    }

    public function getBookCount()
    {
        return $this->hasMany(Books::class, 'catgory_genres_id', 'id')->select(['id', DB::raw('count(catgory_genres_id) as count')]);
    }
}
