<?php

namespace App\Models\LibrarySetting;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class LibrarianPublishers extends Model
{
    use HasFactory,SoftDeletes;
    protected $table="librarian_publishers";
    protected $primaryKey = "id";
    protected $fillable = ['name',
                            'place_id',
                            'phone',
                            'email',
                            'logo',
                            'isfeatured',
                            'status',
                            'website_view'
                          ];
    public function getPlaceName()
    {
            return $this->hasOne(Places::class,'id','place_id');
    }
}
