<?php

namespace App\Models\LibrarySetting;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Racks extends Model
{
    use HasFactory,SoftDeletes;
    protected $table="library_racks";
    protected $primaryKey = "id";
    protected $fillable = ['floor_id',
                            'room_id',
                            'rack_no',
                            'status',
                          ];
    public function getFloorNameOnly()
    {
            return $this->hasOne(Floors::class,'id','floor_id')->select('id','floor_name');
    }
    public function getRoomNameOnly()
    {
            return $this->hasOne(Rooms::class,'id','room_id')->select('id','room_no');
    }
}
