<?php

namespace App\Models\LibrarySetting;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Rooms extends Model
{
    use HasFactory,SoftDeletes;
    protected $table="library_rooms";
    protected $primaryKey = "id";
    protected $fillable = ['floor_id',
                            'room_no',
                            'status',
                          ];
    public function getFloorNameOnly()
    {
            return $this->hasOne(Floors::class,'id','floor_id')->select('id','floor_name');
    }
}
