<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class LicenseActivationHistory extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $appends  = ['services'];
    protected $fillable = [
		"license_id",
		"last_renewal_date",
		"expiry_date",
		"request_extention_date",
		"payment_commitment_date",
		"bill_status",
		"collection_status",
		"remarks",
		"issued_by"
	];

    public function issuedBy()
    {
        return $this->hasOne(User::class, 'id', 'issued_by');
    }

    public function getServicesAttribute()
    {
        $details = LicenseProduct::select(
            'license_products.*',
            'products.name',
            'license_activation_histories.expiry_date'
        )
            // ->leftJoin('license_products', 'license_products.license_id', 'license_details.id')
            ->leftJoin('products', 'products.id', 'license_products.product_id')
            ->leftJoin('license_activation_histories', 'license_activation_histories.license_id', 'license_products.id')
            ->where('license_products.license_id', $this->license_id)
            ->get();

        $products = '';

        foreach ($details as $key => $detail) {
            if (isset($detail->name) && $detail->name != '') {
                $products .= '<b>' . $detail->name . '</b> (' . formatedDate($this->expiry_date) . ')<br>';
            }
        }

        return $products;
    }
}
