<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class LicenseType extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'code',
        'priority',
        'country_id',
        'status',
        'data_length',
        'value_type',
        'is_mandatory',
        'show_in_print'
    ];

    public function country()
    {
        return $this->hasOne(Country::class, 'id', 'country_id');
    }

    public function AccountLicense()
    {
        return $this->hasOne(AccountLicense::class);
    }
}
