<?php

namespace App\Models;

use App\Models\LmsVideoSource;
use App\Models\LmsCourseCategory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasOne;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class LmsCourse extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'course_title',
        'category_id',
        'course_type',
        'language_id',
        'subject_id',
        'course_level',
        'company_id',
        'course_duration',
        'duration_type',
        'tags',
        'short_description',
        'description',
        'thumbnail',
        'is_downloadable',
        'is_free',
        'course_price',
        'meta_title',
        'meta_keywords',
        'open_graph_image',
        'meta_description',
        'class_id',
        'section_id',
        'status'
    ];

    /**
     * Get the Image for the portfolios.
     */
    public function category(): HasOne
    {
        return $this->HasOne(LmsCourseCategory::class, 'id', 'category_id');
    }

    /**
     * Get the Image for the portfolios.
     */
    public function video_source(): HasOne
    {
        return $this->HasOne(LmsVideoSource::class, 'course_id');
    }
}
