<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Marketing extends Model
{
    use HasFactory;
    use SoftDeletes;
    protected $fillable = [
        'name',
        'business_name',
        'gbp_link',
        'rating',
        'total_review',
        'address',
        'website',
        'phone_number',
        'email',
        'claim_status',
        'optimization_score',
        'local_ads',
        'paid_ads',
        'google_ranking',
        'pack_ranking',
        'ai_suggested_services',
        'note',
        'tags',
        'business_category_id',
        'status',
    ];
    public function getBusinessCategory()
    {
        return $this->belongsTo(BusinessCategory::class,'business_category_id');
    }
}
