<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class MasterType extends Model
{
    use HasFactory;
    protected $table = "account_types";

    protected $fillable = [
        'type_name',
        'accounting_group_id',
        'account_category_id',
        'type_code',
        'prefix',
        'status',
        'count',
        'is_default',
        'is_person'
    ];
    public function getAccountingCategory()
    {
        return $this->belongsTo(AccountingGroup::class,'accounting_group_id');
    }
    public function getaccountgroup()
    {
        return $this->belongsTo(MasterCategory::class,'account_category_id');
    }
}
