<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Spatie\Permission\Models\Permission;

class MenuModelPermission extends Model
{
    use HasFactory;

    protected $table      ='menu_model_permissios';
    protected $primaryKey = "id";
    protected $fillable   = [
        'menu_name',
        'status',
        'priority',
        'parent_id',
        'icon',
        'summernote',
        'voucher_master_id',
        'code',
        'color',
        'url',
        'route',
        'route_named',
        'parameters',
        'target',
        'module_type'
    ];

    public function permissions()
    {
        return $this->hasMany(Permission::class, 'module_id', 'id');
    }

    public function childModules()
    {
	    return $this->hasMany(MenuModelPermission::class, 'parent_id', 'id')->with('permissions');
    }

    public function parentModule()
    {
	    return $this->hasOne(MenuModelPermission::class, 'id', 'parent_id');
    }

    public function voucherMaster()
    {
        return $this->hasOne(VoucherMaster::class, 'id', 'voucher_master_id')->with('voucherType');
    }

    public function listingPermissions()
    {
        return $this->hasOne(Permission::class, 'module_id', 'id')->where('name', 'LIKE', '%' . 'list' . '%');
    }
}
