<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class OpdBookingDetail extends Model
{
    use HasFactory, SoftDeletes;
    protected $table = "opd_booking_details";
    protected $primaryKey = "id";
    protected $fillable = [
        'opd_booking_id',
        'product_id',
        'price_id',
        'brand_id',
        'product_price',
        'per_discount',
        'flat_discount',
        'amount',
    ];
    public function getProduct()
    {
        return $this->hasOne(Product::class, 'id', 'product_id')->with('getProductPrice', 'getProductBrand');
    }
}
