<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class OpdBookings extends Model
{
        use HasFactory, SoftDeletes;
        protected $table = "opd_bookings";
        protected $primaryKey = "id";
        protected $fillable = [
                'booking_id',
                'company_id',
                'patient_id',
                'doctor_ac_id',
                'booking_date_time',
                'shift_id',
                'appointment_date_time',
                'appointment_serial_no',
                'check_in_status',
                'check_in_time',
                'invoice_status',
                'service_status',
                'appointment_status',
                'total_billing',
                'special_discount',
                'discount_type',
                'due_balance_amount',
                'payment_mode_id',
                'amount_recieved',
                'reff_no',
                'bussiness_source',
                'sale_remarks',
                'last_count',
                'booking_no',
                'sale_invoice_id',
                'invoice_type',
                'ipd_convert_status',
                'collection_agent_id',
                'refferal_lab_id',
                'chamber_id',
                'batch_id',
                'operator_id',
                'checkout_date_time',
                'consultation_start_date_time',
        ];
        public function getDoctorAccount()
        {
                return $this->hasOne(Account::class, 'id', 'doctor_ac_id')->with('account_contact');
        }
        public function getPatient()
        {
                return $this->hasOne(Account::class, 'id', 'patient_id')->with('account_contact');
        }
        public function getOpdBookingDetails()
        {
                return $this->hasMany(OpdBookingDetail::class, 'opd_booking_id');
        }
        public function getCompany()
        {
                return $this->belongsTo(Company::class, 'company_id')->with('getCompanyAddress')->with('getCompanybank');
        }
        public function getCollectionAgent()
        {
            return $this->hasOne(Account::class, 'id', 'collection_agent_id')->with('first_account_address','account_contact');
        }
    
        public function getRefferalLab()
        {
            return $this->hasOne(Account::class, 'id', 'refferal_lab_id')->with('first_account_address','account_contact');
        }

        public function getShiftNames()
        {
              return $this->hasOne(AppointmentShift::class,'id','shift_id')->select(['id','name']);
        }
        public function getSaleInvoiceDiscount()
        {
                return $this->hasMany(OpdBookingDetail::class,'opd_booking_id')->select(['opd_booking_id',\DB::raw('SUM(flat_discount) as discount_amount')])->groupBy('opd_booking_id');;
        }

        public function getCreatedBy()
        {
        return $this->hasOne(User::class,'id','operator_id')->select(['id','name','prepared_by']);
        }

}
