<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class OpdPrescriptionImage extends Model
{
    use HasFactory, SoftDeletes;
    protected $table = "opd_prescription_images";
    protected $primaryKey = "id";
    protected $fillable = [
        'doctor_id',
        'position',
        'image_url',
        'status',
        'chamber_id',
        'height',
        'width',
        'top_margin',
        'bottom_margin',
        'left_margin',
        'right_margin',
        'top_padding',
        'bottom_padding',
        'left_padding',
        'right_padding',
        'alignment',
    ];

    public function getDoctorAccount()
    {
        return $this->hasOne(Account::class, 'id', 'doctor_ac_id')->with('account_contact');
    }
}
