<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PaymentVoucher extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
		'receipt_no',
		'overall_receipt_no',
		'receipt_date',
		'remarks',
		'module_code',
		'financial_year_id',
		'voucher_id',
		'company_id',
		'created_by',
		'updated_by',
		'deleted_by',
		'voucher_status',
		'last_voucher_count',
		'last_voucher_type_count',
        'receipt_time',
    ];

    public function paymentVoucherDetail(){
        return $this->hasOne(PaymentVoucherDetail::class,'voucher_id','id')->with('account','voucherType','voucherTerm');
    }

    public function paymentVoucherDetails(){
        return $this->hasMany(PaymentVoucherDetail::class,'voucher_id','id');
    }

    public function company(){
        return $this->hasOne(Company::class,'id','company_id');
    }

    public function user(){
        return $this->hasOne(User::class,'id','created_by');
    }

    public function accountReceiptReceivedAmount(){
        return $this->hasMany(PaymentVoucherDetail::class,'voucher_id','id')
        ->select(['amount','id','voucher_id'])
        ->where('transaction_type','CREDIT');
    }
}
