<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PaymentVoucherDetail extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
		'payment_mode_id',
		'voucher_master_id',
		'voucher_id',
		'voucher_type',
		'module_code',
		'account_id',
		'transaction_type',
		'details_narration',
		'amount',
		'created_by',
		'company_id',
		'financial_year_id',
        'transaction_mode_id',
		'transactions_status',
		'transaction_date',
		'transaction_referrence'
    ];

    public function company(){
        return $this->hasOne(Company::class,'id','company_id');
    }
    
    public function user(){
        return $this->hasOne(User::class,'id','created_by');
    }

    public function account(){
        return $this->hasOne(Account::class,'id','account_id')->with('account_contact');
    }

    public function module(){
        return $this->hasOne(MenuModelPermission::class,'code','module_code');
    }

    public function voucherType(){
        return $this->hasOne(VoucherType::class,'code','voucher_type');
    }

    public function voucherTerm(){
        return $this->hasOne(VoucherTerm::class,'voucher_id','voucher_master_id')->where('status', '1')->orderBy('is_default','Desc');
    }

    public function payment_mode()
    {
        return $this->hasOne(PaymentMode::class, 'id', 'transaction_mode_id');
    }
}
