<?php

namespace App\Models;

use App\Models\BookDetails;
use App\Models\LibrarySetting\LibrarianGernes;
use Illuminate\Database\Eloquent\Relations\HasOne;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Product extends Model
{
    use HasFactory;

    protected $appends = ['genre'];
    // protected $with     = ["book_details"];
    protected $fillable = [
        'name',
        'is_book',
        'short_name',
        'description',
        'shortcode',
        'hsncode',
        'tax_slab_id',
        'brand_id',
        'category_id',
        'composition_id',
        'primary_unit_id',
        'alternative_unit_id',
        'convertion_factor',
        'priceasper',
        'manage_stock',
        'item_type_id',
        'attribute_type_id',
        'attribute_id',
        'instance_id',
        'image',
        'file_path',
        'status',
        'sale_status',
        'date',
        'gender_id',
        'item_stock_type',
        'grossweight',
        'netweight',
        'purity',
        'making_charge',
        'additional_cost',
        'item_sale_type',
        'item_min_stock_qty',
        'company_id',
        'flag_id',
        'warehouse_id',
        'attribute_group_main',
        'attribute_group_sub',
        'enable_serial_number_tracking',
        'allow_negative_stock',
        'is_raw_material',
        'last_isbn_no_count',
        'created_by_user_id',
        'updated_by_user_id',
        'business_division_id',
        'additional_info',
        'product_code',
        'product_packaging_id',
    ];
    public function getProductBrand()
    {
        return $this->belongsTo(ProductBrand::class,'brand_id');
    }
    public function getProductPrice()
    {
        return $this->hasOne(ProductPrice::class);
    }
    public function getProductCategory()
    {
        return $this->belongsTo(ProductCategory::class,'category_id');
    }
    public function getProductGroup()
    {
        return $this->belongsTo(ProductGroup::class,'composition_id');
    }
    public function getTaxMaster()
    {
        return $this->belongsTo(TaxMaster::class,'tax_slab_id')->with('getTaxMasterSub');
    }
    // public function book_details(): HasOne
    // {
    //     return $this->HasOne(BookDetails::class, 'book_id');
    // }

    public function getGenreAttribute()
    {
        $genre = LibrarianGernes::find($this->category_id);
        return isset($genre->name) ? $genre->name : '';
    }
    // public function getProductPrice()
    // {
    //     return $this->belongsTo(ProductPrice::class,'id');
    // }
    public function testPackages()
    {
        return $this->belongsToMany(TestPackage::class, 'product_test_package');
    }

    public function getProductPrimaryUnit()
    {
        return $this->hasOne(PrimaryUnit::class,'id','primary_unit_id');
    }
}
