<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ProductFeature extends Model
{
    use HasFactory;
    use SoftDeletes;
    protected $fillable = [
        'product_code',
        'module_code',
        'details',
        'status',
    ];
    public function getProductCode()
    {
        return $this->belongsTo(Product::class,'product_code');
    }
    public function getModuleCode()
    {
        return $this->belongsTo(MenuModelPermission::class,'module_code');
    }
}
