<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ProductLocationRack extends Model
{
    use HasFactory;
    protected $fillable = [
        'name',
        'warehouse_id',
        'company_id',
        'priority',
        'is_default',
        'status',
        'code'
    ];
    public function getCompany()
    {
        return $this->belongsTo(Company::class,'company_id');
    }
    public function getWarehouse()
    {
        return $this->belongsTo(ProductWarehouse::class,'warehouse_id');
    }

}
