<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ProductTestPackage extends Model
{
    use HasFactory;

    public $fillable = [
        'test_package_id',
        'product_id',
        'priority'
    ];

    public function getProduct()
    {
        return $this->hasOne(Product::class,'id','product_id');
    }

    public function getTestPackageGroupTestItem()
    {
        return $this->hasOne(TestPackageGroupTestItem::class,'test_package_id','test_package_id')->with('testPackageItems');
    }

    public function getTestPackage()
    {
        return $this->hasOne(TestPackage::class,'id','test_package_id');
    }
}
