<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ProductWarehouse extends Model
{
    use HasFactory;
    protected $fillable = [
        'state_id',
        'country_id',
        'company_id',
        'name',
        'trade_name',
        'address_1',
        'address_2',
        'place',
        'gst_no',
        'priority',
        'is_default',
        'status',
        'project_id',
        'city_id',
    ];
    public function getCompany()
    {
        return $this->belongsTo(Company::class,'company_id');
    }
    public function getState()
    {
        return $this->belongsTo(State::class,'state_id');
    }
    public function getCountry()
    {
        return $this->belongsTo(Country::class,'country_id');
    }
}
