<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ProjectBudget extends Model
{
    use HasFactory;
    use SoftDeletes;
    protected $fillable = [
        'projects_id',
        'budget_type_id',
        'amount',
        'status'
    ];
    public function getProject()
    {
        return $this->belongsTo(Projects::class,'projects_id');
    }
    public function getBudget()
    {
        return $this->belongsTo(BudgetType::class,'budget_type_id');
    }
}
