<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ProjectRequirement extends Model
{
    use HasFactory;
    use SoftDeletes;
    protected $fillable = [
        "type_id",
        "project_id",
        "features",
        "note",
        "status",
    ];
    public function getProject()
    {
        return $this->belongsTo(Projects::class,'project_id');
    }
    public function getProjectType()
    {
        return $this->belongsTo(ProjectType::class,'type_id');
    }

}
