<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ProjectTeam extends Model
{
    use HasFactory;
    use SoftDeletes;
    protected $fillable = [
        'project_id',
        'team_user_id',
        'role_in_project',
        'is_manager',
        'assign_date',
        'release_date',
        'status'
    ];

    public function getUserId()
    {
        return $this->belongsTo(User::class,'team_user_id');
    }
}
